//
//  DHDMXConstants.h
//  DHDMX
//
//	Constants that may apply to various different protocols
//
//  Created by Douglas Heriot on 3/03/12.
//  Copyright (c) 2012 Douglas Heriot Design. All rights reserved.
//

#import <Foundation/Foundation.h>


enum
{
	DHDMX_UNIVERSE_LENGTH = 512
};


// NSError codes
typedef enum
{
	DHDMXNoError = 0,               // Never used
	
	// Network socket errors
	DHDMXErrorSending = 1,          // Error sending a packet
	DHDMXErrorReceiving = 2,        // Error receiving a packet
	DHDMXErrorBinding = 3,          // Error binding a socket
	DHDMXErrorSocketSetup = 4,      // Error seting socket options
	
	// String input errors
	DHDMXErrorParsingString = 10,   // Failed to parse input string
	DHDMXErrorINET_PTON = 11,       // inet_pton failed
}
DHDMXErrorCode;


extern NSString *const DHDMXErrorDomain;
